--
-- JLichterscript
-- This is the specialization for JLichterscript
--
-- M@D Author  Headshot XXL
-- M@D date 17.07.2009
--
-- > Copyright (C) Headshot XXL - www.planet-ls.de < --

JLichterscript = {};

function JLichterscript.prerequisitesPresent(specializations)
    return true;
end;

function JLichterscript:load(xmlFile)

	self.workLight = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.workLights#index"));
	self.workLight2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.workLights#index2"));
	self.workLightVis = false;
	self.workLight2Vis = false;

	local i = 0;
	self.rundumleuchten = {};
    self.rundumleuchtenAn = false;
	while true do
		local rul = {};
		local objname = string.format("vehicle.rundumleuchten.rundumleuchte(%d)",i);
		local rotnode = getXMLString(xmlFile, objname .. "#rotNode");
    if rotnode == nil then 
      	break;
    end;
    rul = {};
    rul.rotNode = Utils.indexToObject(self.components, rotnode);
    rul.light = Utils.indexToObject(self.components, getXMLString(xmlFile, objname .. "#light"));
    if(rul.rotNode == nil or rul.light == nil) then
      	print("Error: Index ("..rotnode..") zur Rundumleuchte nicht gefunden");
    else
	    rul.speed = Utils.getNoNil(getXMLInt(xmlFile,  objname .. "#rotSpeed"), 1)/1000;
	    rul.source = Utils.indexToObject(self.components, getXMLString(xmlFile, objname .. "#lightsource"));
	    if (rul.source == nil) then
	    	rul.emit = false;
	    else
      		rul.emit = Utils.getNoNil(getXMLBool(xmlFile, objname .. "#emitLight"), true);
      		if not rul.emit then
      			setVisibility(rul.source, false);
      		end;
      	end;
      	table.insert(self.rundumleuchten, rul);
    end;
    i=i+1;
    end;
    self.rundumleuchtenAnz = table.getn(self.rundumleuchten);	
	
    self.keys = {};
    local i=0;
    while true do
        local baseName = string.format("vehicle.keys.input(%d)", i);
        local inputName = getXMLString(xmlFile, baseName.. "#name");
        if inputName == nil then
            break;
        end;
        local inputKey = getXMLString(xmlFile, baseName.. "#key");
        if Input[inputKey] == nil then
            print("Error: invalid key '" .. inputKey .. "'  for input event '" .. inputName .. "'");
            break;
        end;
        self.keys[inputName] = Input[inputKey];
        i = i+1;
    end;	
    self.numbrakelights = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.brakelights#count"), 0);
    self.brakelights = {};
    for i=1, self.numbrakelights do
        local brakelightnamei = string.format("vehicle.brakelights.brakelight" .. "%d", i);
        self.brakelights[i] = Utils.indexToObject(self.rootNode, getXMLInt(xmlFile, brakelightnamei .. "#index"));
        setVisibility(self.brakelights[i], false);
    end;
	self.brakelightsActive = false;

	self.numbacklights = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.backlights#count"), 0);
    self.backlights = {};
    for i=1, self.numbacklights do
        local backlightnamei = string.format("vehicle.backlights.backlight" .. "%d", i);
        self.backlights[i] = Utils.indexToObject(self.rootNode, getXMLInt(xmlFile, backlightnamei .. "#index"));
        setVisibility(self.backlights[i], false);
    end;
	self.backlightsActive = false;

    local brakeSound1 = getXMLString(xmlFile, "vehicle.brakeSound1#file");
    if brakeSound1 ~= nil and brakeSound1 ~= "" then
        brakeSound1 = Utils.getFilename(brakeSound1, self.baseDirectory);
        self.brakeSound1 = createSample("brakeSound1");
        self.brakeSound1Enabled = false;
        loadSample(self.brakeSound1, brakeSound1, false);
        self.brakeSound1PitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.brakeSound1#pitchOffset"), 1);
        self.brakeSound1Volume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.brakeSound1#volume"), 1);
    end;


end;

function JLichterscript:delete()
    if self.brakeSound1 ~= nil then
        delete(self.brakeSound1);
    end;
end;

function JLichterscript:mouseEvent(posX, posY, isDown, isUp, button)
end;

function JLichterscript:keyEvent(unicode, sym, modifier, isDown)
end;

function JLichterscript:update(dt)

	if self.isEntered then
self.input = InputBinding.getAnalogInputAxis(InputBinding.AXIS_MOVE_FORWARD_VEHICLE);

	if InputBinding.isAxisZero(self.input) then
        	self.input = InputBinding.getDigitalInputAxis(InputBinding.AXIS_MOVE_FORWARD_VEHICLE);
	end;

	if self.brakelightsActive then
		for i=1, self.numbrakelights do
			local brakelight = self.brakelights[i];
			setVisibility(brakelight, self.brakelightsActive);
		end;
	else
		for i=1, self.numbrakelights do
			local brakelight = self.brakelights[i];
			setVisibility(brakelight, self.brakelightsActive, false);
		end;
	end;


	if self.backlightsActive then
		for i=1, self.numbacklights do
			local backlight = self.backlights[i];
			setVisibility(backlight, self.backlightsActive);
		end;
	else
		for i=1, self.numbacklights do
			local backlight = self.backlights[i];
			setVisibility(backlight, self.backlightsActive, false);
		end;
	end;

	if -self.input < -0.001 and self.movingDirection > 0 then
		self.brakelightsActive = true;
		self.motor.brakeForce = -self.input*-50;
	elseif -self.input > 0.001 and self.movingDirection < 0 then
    		self.brakelightsActive = true;
		self.motor.brakeForce = -self.input*25;
	else
		self.brakelightsActive = false;
		self.motor.brakeForce = 10;
	end;
	if self.movingDirection < 0 then
    		self.backlightsActive = true;
	else
		self.backlightsActive = false;
	end;

	if self.movingDirection > 0 then
            if self.brakeSound1 ~= nil then
                if -self.input < -0.001 and self.brakeSound1Enabled then
                    self.brakeSound1Enabled = false;
                end;

                if -self.input < -0.001 and not self.brakeSound1Enabled then
                    if self:getIsActiveForSound() then
                        playSample(self.brakeSound1, 1, self.brakeSound1Volume, 0);
                        setSamplePitch(self.brakesound1Sound, self.brakeSound1PitchOffset);
                    end;
                    self.brakeSound1Enabled = true;
                end;

            end;
	end;
	if self.movingDirection < 0 then
            if self.brakeSound1 ~= nil then
                if -self.input > 0.001 and self.brakeSound1Enabled then
                    self.brakeSound1Enabled = false;
                end;

                if -self.input > 0.001 and not self.brakeSound1Enabled then
                    if self:getIsActiveForSound() then
                        playSample(self.brakeSound1, 1, self.brakeSound1Volume, 0);
                        setSamplePitch(self.brakesound1Sound, self.brakeSound1PitchOffset);
                    end;
                    self.brakeSound1Enabled = true;
                end;

            end;
	end;
		if self.workLight ~= nil then
			if InputBinding.hasEvent(InputBinding.Jaguar890WORKLIGHT) then
				self.workLightVis = not self.workLightVis;
			end;
		end;
		if self.workLight2 ~= nil then
			if InputBinding.hasEvent(InputBinding.Jaguar890WORKLIGHT2) then
				self.workLight2Vis = not self.workLight2Vis;
			end;
		end;
	end;
	
	if self.workLight ~= nil then
		setVisibility(self.workLight, self.workLightVis);
	end;
	if self.workLight2 ~= nil then
		setVisibility(self.workLight2, self.workLight2Vis);
	end;
		
	if self.rundumleuchtenAnz > 0 and self:getIsActive() then
		if InputBinding.hasEvent(InputBinding.Jaguar890RUNDUMLEUCHTE) then
			self.rundumleuchtenAn = not self.rundumleuchtenAn;
			for i=1, self.rundumleuchtenAnz do
				setVisibility(self.rundumleuchten[i].light, self.rundumleuchtenAn);
			end;
		end;
		if self.rundumleuchtenAn then
			for i=1, self.rundumleuchtenAnz do
				rotate(self.rundumleuchten[i].rotNode, 0, dt*self.rundumleuchten[i].speed, 0);
			end;
		end;
	end;

end;

function JLichterscript:onEnter()

	self.isActor = self.isEntered;
end;

function JLichterscript:onLeave()

    self.brakelightsActive = false;
    self.backlightsActive = false;

end;

function JLichterscript:draw()
		if self.isEntered then
			g_currentMission:addHelpButtonText(string.format(g_i18n:getText("Jaguar890WORKLIGHT"), self.typeDesc), InputBinding.Jaguar890WORKLIGHT);
			g_currentMission:addHelpButtonText(string.format(g_i18n:getText("Jaguar890WORKLIGHT2"), self.typeDesc), InputBinding.Jaguar890WORKLIGHT2);
			g_currentMission:addHelpButtonText(string.format(g_i18n:getText("Jaguar890RUNDUMLEUCHTE"), self.typeDesc), InputBinding.Jaguar890RUNDUMLEUCHTE);
		end;
end;